<?php
$api_url = 'http://localhost/jps-service/backend/routers/chamados.php';
$data = json_decode(file_get_contents($api_url), true);

// Função para formatar valores se necessário
function formatValue($value) {
    if (is_numeric($value)) {
        return number_format(floatval($value), 2, ',', '.');
    }
    return $value;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestão de Chamados</title>
    <link rel="stylesheet" type="text/css"
        href="https://cdn.datatables.net/v/bs5/jq-3.6.0/dt-1.11.5/datatables.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
    .btn-action {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
        line-height: 1.5;
    }

    .modal-lg-custom {
        max-width: 800px;
    }
    </style>
</head>

<body>
    <div class="container-fluid mt-4">
        <h1 class="mb-4">Gestão de Chamados</h1>

        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Lista de Chamados</h5>
                <div>
                    <a href="http://localhost/jps-service/frontend/index.php?page=chamadosAdd" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus me-1"></i> Novo Registro
                    </a>
                </div>
            </div>
            <div class="card-body">
                <table id="dataTable" class="table table-striped table-bordered nowrap" style="width:100%">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Maquina</th>
                            <th>Setor</th>
                            <th>Cidade</th>
                            <th>Uf</th>
                            <th>Atendente</th>
                            <th>Cliente Nome</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($data as $item): ?>
                        <tr>
                            <td><?= formatValue($item["id"]) ?></td>
                            <td><?= formatValue($item["maquina"]) ?></td>
                            <td><?= formatValue($item["setor"]) ?></td>
                            <td><?= formatValue($item["cidade"]) ?></td>
                            <td><?= formatValue($item["uf"]) ?></td>
                            <td><?= formatValue($item["fk_atendente"]) ?></td>
                            <td><?= formatValue($item["cliente_nome"]) ?></td>
                            <td>
                                <a href="http://localhost/jps-service/frontend/modules/relatorios/relatorio_chamado.php?id=<?= $item["id"] ?>" target="_blank" class="btn btn-white btn-action btn-print">
    <i class="fas fa-print"></i>
</a>
                                <button class="btn btn-info btn-action btn-view" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="btn btn-warning btn-action btn-edit" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-danger btn-action btn-delete" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal Visualizar -->
    <div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewModalLabel">Detalhes</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="viewModalBody">
                    <!-- Conteúdo será preenchido via AJAX -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Editar -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">Editar</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editForm" method="POST">
                    <div class="modal-body" id="editModalBody">
                        <!-- Conteúdo será preenchido via AJAX -->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Excluir -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Você tem certeza que deseja excluir este registro? Esta ação não pode ser desfeita.</p>
                    <input type="hidden" id="deleteId">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-danger" id="confirmDelete">Excluir</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Cadastrar -->
    <div class="modal fade" id="cadastrarModal" tabindex="-1" aria-labelledby="cadastrarModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="cadastrarModalLabel">Cadastrar Novo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="cadastrarForm" method="POST">
                    <div class="modal-body">
                        <div class="row g-3">

                            <div class="col-md-6">
                                <label for="dt_cad" class="form-label">Dt Cad</label>
                                <input type="text" class="form-control" id="dt_cad" name="dt_cad" required>
                            </div>

                            <div class="col-md-6">
                                <label for="fk_cliente" class="form-label">Fk Cliente</label>
                                <input type="text" class="form-control" id="fk_cliente" name="fk_cliente" required>
                            </div>

                            <div class="col-md-6">
                                <label for="cliente_solicitante" class="form-label">Cliente Solicitante</label>
                                <input type="text" class="form-control" id="cliente_solicitante"
                                    name="cliente_solicitante" required>
                            </div>

                            <div class="col-md-6">
                                <label for="serie" class="form-label">Serie</label>
                                <input type="text" class="form-control" id="serie" name="serie" required>
                            </div>

                            <div class="col-md-6">
                                <label for="maquina" class="form-label">Maquina</label>
                                <input type="text" class="form-control" id="maquina" name="maquina" required>
                            </div>

                            <div class="col-md-6">
                                <label for="setor" class="form-label">Setor</label>
                                <input type="text" class="form-control" id="setor" name="setor" required>
                            </div>

                            <div class="col-md-6">
                                <label for="endereco" class="form-label">Endereco</label>
                                <input type="text" class="form-control" id="endereco" name="endereco" required>
                            </div>

                            <div class="col-md-6">
                                <label for="cidade" class="form-label">Cidade</label>
                                <input type="text" class="form-control" id="cidade" name="cidade" required>
                            </div>

                            <div class="col-md-6">
                                <label for="uf" class="form-label">Uf</label>
                                <input type="text" class="form-control" id="uf" name="uf" required>
                            </div>

                            <div class="col-md-6">
                                <label for="fk_servico_tipo" class="form-label">Fk Servico Tipo</label>
                                <input type="text" class="form-control" id="fk_servico_tipo" name="fk_servico_tipo"
                                    required>
                            </div>

                            <div class="col-md-6">
                                <label for="fk_servico" class="form-label">Fk Servico</label>
                                <input type="text" class="form-control" id="fk_servico" name="fk_servico" required>
                            </div>

                            <div class="col-md-6">
                                <label for="fk_solucao_proposta" class="form-label">Fk Solucao Proposta</label>
                                <input type="text" class="form-control" id="fk_solucao_proposta"
                                    name="fk_solucao_proposta" required>
                            </div>

                            <div class="col-md-6">
                                <label for="fk_atendente" class="form-label">Fk Atendente</label>
                                <input type="text" class="form-control" id="fk_atendente" name="fk_atendente" required>
                            </div>

                            <div class="col-md-6">
                                <label for="detalhes" class="form-label">Detalhes</label>
                                <input type="text" class="form-control" id="detalhes" name="detalhes" required>
                            </div>

                            <div class="col-md-6">
                                <label for="anexo" class="form-label">Anexo</label>
                                <input type="text" class="form-control" id="anexo" name="anexo" required>
                            </div>

                            <div class="col-md-6">
                                <label for="cliente_nome" class="form-label">Cliente Nome</label>
                                <input type="text" class="form-control" id="cliente_nome" name="cliente_nome" required>
                            </div>

                            <div class="col-md-6">
                                <label for="servico_tipo_desc" class="form-label">Servico Tipo Desc</label>
                                <input type="text" class="form-control" id="servico_tipo_desc" name="servico_tipo_desc"
                                    required>
                            </div>

                            <div class="col-md-6">
                                <label for="servico_desc" class="form-label">Servico Desc</label>
                                <input type="text" class="form-control" id="servico_desc" name="servico_desc" required>
                            </div>

                            <div class="col-md-6">
                                <label for="solucao" class="form-label">Solucao</label>
                                <input type="text" class="form-control" id="solucao" name="solucao" required>
                            </div>

                            <div class="col-md-6">
                                <label for="atendente_nome" class="form-label">Atendente Nome</label>
                                <input type="text" class="form-control" id="atendente_nome" name="atendente_nome"
                                    required>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Cadastrar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- jQuery, Bootstrap e DataTables JS -->
    <script type="text/javascript" src="https://cdn.datatables.net/v/bs5/jq-3.6.0/dt-1.11.5/datatables.min.js"></script>
    <!-- Excel export -->
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>

    <script>
    $(document).ready(function() {
        // Inicialização do DataTable com botão de exportação
        var table = $('#dataTable').DataTable({
            responsive: true,
            dom: 'Bfrtip',
            buttons: [{
                extend: 'excel',
                text: '<i class="fas fa-file-excel me-1"></i> Exportar Excel',
                className: 'btn btn-success btn-sm',
                title: 'Chamados',
                exportOptions: {
                    columns: ':not(:last-child)' // Exclui a coluna de ações
                }
            }],
            language: {
                url: 'https://cdn.datatables.net/plug-ins/1.11.5/i18n/pt-BR.json'
            }
        });

        // Visualizar registro
        $(document).on('click', '.btn-view', function() {
            var id = $(this).data('id');
            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'GET',
                dataType: 'json',
                success: function(item) {
                    var html = '<div class="row">';
                    html += `
                            <div class="col-md-6">
                                <p><strong>Id:</strong> ${item['id'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Dt Cad:</strong> ${item['dt_cad'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Fk Cliente:</strong> ${item['fk_cliente'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Cliente Solicitante:</strong> ${item['cliente_solicitante'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Serie:</strong> ${item['serie'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Maquina:</strong> ${item['maquina'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Setor:</strong> ${item['setor'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Endereco:</strong> ${item['endereco'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Cidade:</strong> ${item['cidade'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Uf:</strong> ${item['uf'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Fk Servico Tipo:</strong> ${item['fk_servico_tipo'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Fk Servico:</strong> ${item['fk_servico'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Fk Solucao Proposta:</strong> ${item['fk_solucao_proposta'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Fk Atendente:</strong> ${item['fk_atendente'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Detalhes:</strong> ${item['detalhes'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Anexo:</strong> ${item['anexo'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Cliente Nome:</strong> ${item['cliente_nome'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Servico Tipo Desc:</strong> ${item['servico_tipo_desc'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Servico Desc:</strong> ${item['servico_desc'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Solucao:</strong> ${item['solucao'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Atendente Nome:</strong> ${item['atendente_nome'] || 'N/A'}</p>
                            </div>
                        `;
                    html += '</div>';
                    $('#viewModalBody').html(html);
                    $('#viewModal').modal('show');
                },
                error: function(xhr, status, error) {
                    alert('Erro ao carregar registro: ' + error);
                }
            });
        });

        // Editar registro - Abrir modal
        $(document).on('click', '.btn-edit', function() {
            var id = $(this).data('id');
            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'GET',
                dataType: 'json',
                success: function(item) {
                    var html = '<input type="hidden" name="id" value="' + item.id + '">';
                    html += '<div class="row g-3">';
                    html += `
                            <div class="col-md-6">
                                <label for="edit_dt_cad" class="form-label">Dt Cad</label>
                                <input type="text" class="form-control" id="edit_dt_cad" name="dt_cad" value="${item['dt_cad'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_fk_cliente" class="form-label">Fk Cliente</label>
                                <input type="text" class="form-control" id="edit_fk_cliente" name="fk_cliente" value="${item['fk_cliente'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_cliente_solicitante" class="form-label">Cliente Solicitante</label>
                                <input type="text" class="form-control" id="edit_cliente_solicitante" name="cliente_solicitante" value="${item['cliente_solicitante'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_serie" class="form-label">Serie</label>
                                <input type="text" class="form-control" id="edit_serie" name="serie" value="${item['serie'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_maquina" class="form-label">Maquina</label>
                                <input type="text" class="form-control" id="edit_maquina" name="maquina" value="${item['maquina'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_setor" class="form-label">Setor</label>
                                <input type="text" class="form-control" id="edit_setor" name="setor" value="${item['setor'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_endereco" class="form-label">Endereco</label>
                                <input type="text" class="form-control" id="edit_endereco" name="endereco" value="${item['endereco'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_cidade" class="form-label">Cidade</label>
                                <input type="text" class="form-control" id="edit_cidade" name="cidade" value="${item['cidade'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_uf" class="form-label">Uf</label>
                                <input type="text" class="form-control" id="edit_uf" name="uf" value="${item['uf'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_fk_servico_tipo" class="form-label">Fk Servico Tipo</label>
                                <input type="text" class="form-control" id="edit_fk_servico_tipo" name="fk_servico_tipo" value="${item['fk_servico_tipo'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_fk_servico" class="form-label">Fk Servico</label>
                                <input type="text" class="form-control" id="edit_fk_servico" name="fk_servico" value="${item['fk_servico'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_fk_solucao_proposta" class="form-label">Fk Solucao Proposta</label>
                                <input type="text" class="form-control" id="edit_fk_solucao_proposta" name="fk_solucao_proposta" value="${item['fk_solucao_proposta'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_fk_atendente" class="form-label">Fk Atendente</label>
                                <input type="text" class="form-control" id="edit_fk_atendente" name="fk_atendente" value="${item['fk_atendente'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_detalhes" class="form-label">Detalhes</label>
                                <input type="text" class="form-control" id="edit_detalhes" name="detalhes" value="${item['detalhes'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_anexo" class="form-label">Anexo</label>
                                <input type="text" class="form-control" id="edit_anexo" name="anexo" value="${item['anexo'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_cliente_nome" class="form-label">Cliente Nome</label>
                                <input type="text" class="form-control" id="edit_cliente_nome" name="cliente_nome" value="${item['cliente_nome'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_servico_tipo_desc" class="form-label">Servico Tipo Desc</label>
                                <input type="text" class="form-control" id="edit_servico_tipo_desc" name="servico_tipo_desc" value="${item['servico_tipo_desc'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_servico_desc" class="form-label">Servico Desc</label>
                                <input type="text" class="form-control" id="edit_servico_desc" name="servico_desc" value="${item['servico_desc'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_solucao" class="form-label">Solucao</label>
                                <input type="text" class="form-control" id="edit_solucao" name="solucao" value="${item['solucao'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_atendente_nome" class="form-label">Atendente Nome</label>
                                <input type="text" class="form-control" id="edit_atendente_nome" name="atendente_nome" value="${item['atendente_nome'] || ''}" required>
                            </div>
                        `;
                    html += '</div>';
                    $('#editModalBody').html(html);
                    $('#editModal').modal('show');
                },
                error: function(xhr, status, error) {
                    alert('Erro ao carregar registro para edição: ' + error);
                }
            });
        });

        // Submit do formulário de edição
        $('#editForm').submit(function(e) {
            e.preventDefault();
            var id = $('input[name="id"]').val();
            var formData = {
                "dt_cad": $("#edit_dt_cad").val(),
                "fk_cliente": $("#edit_fk_cliente").val(),
                "cliente_solicitante": $("#edit_cliente_solicitante").val(),
                "serie": $("#edit_serie").val(),
                "maquina": $("#edit_maquina").val(),
                "setor": $("#edit_setor").val(),
                "endereco": $("#edit_endereco").val(),
                "cidade": $("#edit_cidade").val(),
                "uf": $("#edit_uf").val(),
                "fk_servico_tipo": $("#edit_fk_servico_tipo").val(),
                "fk_servico": $("#edit_fk_servico").val(),
                "fk_solucao_proposta": $("#edit_fk_solucao_proposta").val(),
                "fk_atendente": $("#edit_fk_atendente").val(),
                "detalhes": $("#edit_detalhes").val(),
                "anexo": $("#edit_anexo").val(),
                "cliente_nome": $("#edit_cliente_nome").val(),
                "servico_tipo_desc": $("#edit_servico_tipo_desc").val(),
                "servico_desc": $("#edit_servico_desc").val(),
                "solucao": $("#edit_solucao").val(),
                "atendente_nome": $("#edit_atendente_nome").val()
            };

            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'PUT',
                contentType: 'application/json',
                data: JSON.stringify(formData),
                success: function(response) {
                    alert('Registro atualizado com sucesso!');
                    $('#editModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao atualizar o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });

        // Excluir registro
        $(document).on('click', '.btn-delete', function() {
            var id = $(this).data('id');
            $('#deleteId').val(id);
            $('#deleteModal').modal('show');
        });

        // Confirmar exclusão
        $('#confirmDelete').click(function() {
            var id = $('#deleteId').val();

            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'DELETE',
                success: function(response) {
                    alert('Registro excluído com sucesso!');
                    $('#deleteModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao excluir o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });

        // Submit do formulário de cadastro
        $('#cadastrarForm').submit(function(e) {
            e.preventDefault();
            var formData = {
                "dt_cad": $("#dt_cad").val(),
                "fk_cliente": $("#fk_cliente").val(),
                "cliente_solicitante": $("#cliente_solicitante").val(),
                "serie": $("#serie").val(),
                "maquina": $("#maquina").val(),
                "setor": $("#setor").val(),
                "endereco": $("#endereco").val(),
                "cidade": $("#cidade").val(),
                "uf": $("#uf").val(),
                "fk_servico_tipo": $("#fk_servico_tipo").val(),
                "fk_servico": $("#fk_servico").val(),
                "fk_solucao_proposta": $("#fk_solucao_proposta").val(),
                "fk_atendente": $("#fk_atendente").val(),
                "detalhes": $("#detalhes").val(),
                "anexo": $("#anexo").val(),
                "cliente_nome": $("#cliente_nome").val(),
                "servico_tipo_desc": $("#servico_tipo_desc").val(),
                "servico_desc": $("#servico_desc").val(),
                "solucao": $("#solucao").val(),
                "atendente_nome": $("#atendente_nome").val()
            };

            $.ajax({
                url: '<?= $api_url ?>',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(formData),
                success: function(response) {
                    alert('Registro cadastrado com sucesso!');
                    $('#cadastrarModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao cadastrar o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });
    });
    </script>
</body>

</html>