<?php
$api_url = 'http://localhost/jps-service/backend/routers/cliente.php';
$data = json_decode(file_get_contents($api_url), true);

// Função para formatar valores se necessário
function formatValue($value) {
    if (is_numeric($value)) {
        return number_format(floatval($value), 2, ',', '.');
    }
    return $value;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestão de Cliente</title>
    <link rel="stylesheet" type="text/css"
        href="https://cdn.datatables.net/v/bs5/jq-3.6.0/dt-1.11.5/datatables.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
    .btn-action {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
        line-height: 1.5;
    }

    .modal-lg-custom {
        max-width: 800px;
    }
    </style>
</head>

<body>
    <div class="container-fluid mt-4">
        <h1 class="mb-4">Gestão de Cliente</h1>

        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Lista de Cliente</h5>
                <div>
                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#cadastrarModal">
                        <i class="fas fa-plus me-1"></i> Novo Registro
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="dataTable" class="table table-striped table-bordered nowrap" style="width:100%">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Cnpj</th>
                            <th>Nome Rs</th>
                            <th>Bairro</th>
                            <th>Cidade</th>
                            <th>Uf</th>
                            <th>Cep</th>
                            <th>Status</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($data as $item): ?>
                        <tr>
                            <td><?= formatValue($item["id"]) ?></td>
                            <td><?= formatValue($item["cnpj"]) ?></td>
                            <td><?= formatValue($item["nome_rs"]) ?></td>
                            <td><?= formatValue($item["bairro"]) ?></td>
                            <td><?= formatValue($item["cidade"]) ?></td>
                            <td><?= formatValue($item["uf"]) ?></td>
                            <td><?= formatValue($item["cep"]) ?></td>
                            <td><?= formatValue($item["status"]) ?></td>
                            <td>
                                <button class="btn btn-info btn-action btn-view" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="btn btn-warning btn-action btn-edit" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-danger btn-action btn-delete" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal Visualizar -->
    <div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewModalLabel">Detalhes</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="viewModalBody">
                    <!-- Conteúdo será preenchido via AJAX -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Editar -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">Editar</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editForm" method="POST">
                    <div class="modal-body" id="editModalBody">
                        <!-- Conteúdo será preenchido via AJAX -->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Excluir -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Você tem certeza que deseja excluir este registro? Esta ação não pode ser desfeita.</p>
                    <input type="hidden" id="deleteId">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-danger" id="confirmDelete">Excluir</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Cadastrar -->
    <div class="modal fade" id="cadastrarModal" tabindex="-1" aria-labelledby="cadastrarModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="cadastrarModalLabel">Cadastrar Novo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="cadastrarForm" method="POST">
                    <div class="modal-body">
                        <div class="row g-3">

                            <div class="col-md-6">
                                <label for="logo" class="form-label">Logo</label>
                                <input type="text" class="form-control" id="logo" name="logo" required>
                            </div>

                            <div class="col-md-6">
                                <label for="cnpj" class="form-label">Cnpj</label>
                                <input type="text" class="form-control" id="cnpj" name="cnpj" required>
                            </div>

                            <div class="col-md-6">
                                <label for="insc_est" class="form-label">Insc Est</label>
                                <input type="text" class="form-control" id="insc_est" name="insc_est" required>
                            </div>

                            <div class="col-md-6">
                                <label for="insc_mun" class="form-label">Insc Mun</label>
                                <input type="text" class="form-control" id="insc_mun" name="insc_mun" required>
                            </div>

                            <div class="col-md-6">
                                <label for="nome_rs" class="form-label">Nome Rs</label>
                                <input type="text" class="form-control" id="nome_rs" name="nome_rs" required>
                            </div>

                            <div class="col-md-6">
                                <label for="nome_fan" class="form-label">Nome Fan</label>
                                <input type="text" class="form-control" id="nome_fan" name="nome_fan" required>
                            </div>

                            <div class="col-md-6">
                                <label for="nome_representante" class="form-label">Nome Representante</label>
                                <input type="text" class="form-control" id="nome_representante"
                                    name="nome_representante" required>
                            </div>

                            <div class="col-md-6">
                                <label for="cpf" class="form-label">Cpf</label>
                                <input type="text" class="form-control" id="cpf" name="cpf" required>
                            </div>

                            <div class="col-md-6">
                                <label for="fone" class="form-label">Fone</label>
                                <input type="text" class="form-control" id="fone" name="fone" required>
                            </div>

                            <div class="col-md-6">
                                <label for="fax" class="form-label">Fax</label>
                                <input type="text" class="form-control" id="fax" name="fax" required>
                            </div>

                            <div class="col-md-6">
                                <label for="cel" class="form-label">Cel</label>
                                <input type="text" class="form-control" id="cel" name="cel" required>
                            </div>

                            <div class="col-md-6">
                                <label for="email" class="form-label">Email</label>
                                <input type="text" class="form-control" id="email" name="email" required>
                            </div>

                            <div class="col-md-6">
                                <label for="site" class="form-label">Site</label>
                                <input type="text" class="form-control" id="site" name="site" required>
                            </div>

                            <div class="col-md-6">
                                <label for="endereco" class="form-label">Endereco</label>
                                <input type="text" class="form-control" id="endereco" name="endereco" required>
                            </div>

                            <div class="col-md-6">
                                <label for="numero" class="form-label">Numero</label>
                                <input type="text" class="form-control" id="numero" name="numero" required>
                            </div>

                            <div class="col-md-6">
                                <label for="complemento" class="form-label">Complemento</label>
                                <input type="text" class="form-control" id="complemento" name="complemento" required>
                            </div>

                            <div class="col-md-6">
                                <label for="bairro" class="form-label">Bairro</label>
                                <input type="text" class="form-control" id="bairro" name="bairro" required>
                            </div>

                            <div class="col-md-6">
                                <label for="cidade" class="form-label">Cidade</label>
                                <input type="text" class="form-control" id="cidade" name="cidade" required>
                            </div>

                            <div class="col-md-6">
                                <label for="uf" class="form-label">Uf</label>
                                <input type="text" class="form-control" id="uf" name="uf" required>
                            </div>

                            <div class="col-md-6">
                                <label for="cep" class="form-label">Cep</label>
                                <input type="text" class="form-control" id="cep" name="cep" required>
                            </div>

                            <div class="col-md-6">
                                <label for="status" class="form-label">Status</label>
                                <input type="text" class="form-control" id="status" name="status" required>
                            </div>

                            <div class="col-md-6">
                                <label for="localizacao" class="form-label">Localizacao</label>
                                <input type="text" class="form-control" id="localizacao" name="localizacao" required>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Cadastrar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- jQuery, Bootstrap e DataTables JS -->
    <script type="text/javascript" src="https://cdn.datatables.net/v/bs5/jq-3.6.0/dt-1.11.5/datatables.min.js"></script>
    <!-- Excel export -->
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>

    <script>
    $(document).ready(function() {
        // Inicialização do DataTable com botão de exportação
        var table = $('#dataTable').DataTable({
            responsive: true,
            dom: 'Bfrtip',
            buttons: [{
                extend: 'excel',
                text: '<i class="fas fa-file-excel me-1"></i> Exportar Excel',
                className: 'btn btn-success btn-sm',
                title: 'Cliente',
                exportOptions: {
                    columns: ':not(:last-child)' // Exclui a coluna de ações
                }
            }],
            language: {
                url: 'https://cdn.datatables.net/plug-ins/1.11.5/i18n/pt-BR.json'
            }
        });

        // Visualizar registro
        $(document).on('click', '.btn-view', function() {
            var id = $(this).data('id');
            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'GET',
                dataType: 'json',
                success: function(item) {
                    var html = '<div class="row">';
                    html += `
                            <div class="col-md-6">
                                <p><strong>Id:</strong> ${item['id'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Logo:</strong> ${item['logo'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Cnpj:</strong> ${item['cnpj'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Insc Est:</strong> ${item['insc_est'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Insc Mun:</strong> ${item['insc_mun'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Nome Rs:</strong> ${item['nome_rs'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Nome Fan:</strong> ${item['nome_fan'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Nome Representante:</strong> ${item['nome_representante'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Cpf:</strong> ${item['cpf'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Fone:</strong> ${item['fone'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Fax:</strong> ${item['fax'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Cel:</strong> ${item['cel'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Email:</strong> ${item['email'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Site:</strong> ${item['site'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Endereco:</strong> ${item['endereco'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Numero:</strong> ${item['numero'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Complemento:</strong> ${item['complemento'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Bairro:</strong> ${item['bairro'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Cidade:</strong> ${item['cidade'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Uf:</strong> ${item['uf'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Cep:</strong> ${item['cep'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Status:</strong> ${item['status'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Localizacao:</strong> ${item['localizacao'] || 'N/A'}</p>
                            </div>
                        `;
                    html += '</div>';
                    $('#viewModalBody').html(html);
                    $('#viewModal').modal('show');
                },
                error: function(xhr, status, error) {
                    alert('Erro ao carregar registro: ' + error);
                }
            });
        });

        // Editar registro - Abrir modal
        $(document).on('click', '.btn-edit', function() {
            var id = $(this).data('id');
            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'GET',
                dataType: 'json',
                success: function(item) {
                    var html = '<input type="hidden" name="id" value="' + item.id + '">';
                    html += '<div class="row g-3">';
                    html += `
                            <div class="col-md-6">
                                <label for="edit_logo" class="form-label">Logo</label>
                                <input type="text" class="form-control" id="edit_logo" name="logo" value="${item['logo'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_cnpj" class="form-label">Cnpj</label>
                                <input type="text" class="form-control" id="edit_cnpj" name="cnpj" value="${item['cnpj'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_insc_est" class="form-label">Insc Est</label>
                                <input type="text" class="form-control" id="edit_insc_est" name="insc_est" value="${item['insc_est'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_insc_mun" class="form-label">Insc Mun</label>
                                <input type="text" class="form-control" id="edit_insc_mun" name="insc_mun" value="${item['insc_mun'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_nome_rs" class="form-label">Nome Rs</label>
                                <input type="text" class="form-control" id="edit_nome_rs" name="nome_rs" value="${item['nome_rs'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_nome_fan" class="form-label">Nome Fan</label>
                                <input type="text" class="form-control" id="edit_nome_fan" name="nome_fan" value="${item['nome_fan'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_nome_representante" class="form-label">Nome Representante</label>
                                <input type="text" class="form-control" id="edit_nome_representante" name="nome_representante" value="${item['nome_representante'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_cpf" class="form-label">Cpf</label>
                                <input type="text" class="form-control" id="edit_cpf" name="cpf" value="${item['cpf'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_fone" class="form-label">Fone</label>
                                <input type="text" class="form-control" id="edit_fone" name="fone" value="${item['fone'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_fax" class="form-label">Fax</label>
                                <input type="text" class="form-control" id="edit_fax" name="fax" value="${item['fax'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_cel" class="form-label">Cel</label>
                                <input type="text" class="form-control" id="edit_cel" name="cel" value="${item['cel'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_email" class="form-label">Email</label>
                                <input type="text" class="form-control" id="edit_email" name="email" value="${item['email'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_site" class="form-label">Site</label>
                                <input type="text" class="form-control" id="edit_site" name="site" value="${item['site'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_endereco" class="form-label">Endereco</label>
                                <input type="text" class="form-control" id="edit_endereco" name="endereco" value="${item['endereco'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_numero" class="form-label">Numero</label>
                                <input type="text" class="form-control" id="edit_numero" name="numero" value="${item['numero'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_complemento" class="form-label">Complemento</label>
                                <input type="text" class="form-control" id="edit_complemento" name="complemento" value="${item['complemento'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_bairro" class="form-label">Bairro</label>
                                <input type="text" class="form-control" id="edit_bairro" name="bairro" value="${item['bairro'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_cidade" class="form-label">Cidade</label>
                                <input type="text" class="form-control" id="edit_cidade" name="cidade" value="${item['cidade'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_uf" class="form-label">Uf</label>
                                <input type="text" class="form-control" id="edit_uf" name="uf" value="${item['uf'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_cep" class="form-label">Cep</label>
                                <input type="text" class="form-control" id="edit_cep" name="cep" value="${item['cep'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_status" class="form-label">Status</label>
                                <input type="text" class="form-control" id="edit_status" name="status" value="${item['status'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_localizacao" class="form-label">Localizacao</label>
                                <input type="text" class="form-control" id="edit_localizacao" name="localizacao" value="${item['localizacao'] || ''}" required>
                            </div>
                        `;
                    html += '</div>';
                    $('#editModalBody').html(html);
                    $('#editModal').modal('show');
                },
                error: function(xhr, status, error) {
                    alert('Erro ao carregar registro para edição: ' + error);
                }
            });
        });

        // Submit do formulário de edição
        $('#editForm').submit(function(e) {
            e.preventDefault();
            var id = $('input[name="id"]').val();
            var formData = {
                "logo": $("#edit_logo").val(),
                "cnpj": $("#edit_cnpj").val(),
                "insc_est": $("#edit_insc_est").val(),
                "insc_mun": $("#edit_insc_mun").val(),
                "nome_rs": $("#edit_nome_rs").val(),
                "nome_fan": $("#edit_nome_fan").val(),
                "nome_representante": $("#edit_nome_representante").val(),
                "cpf": $("#edit_cpf").val(),
                "fone": $("#edit_fone").val(),
                "fax": $("#edit_fax").val(),
                "cel": $("#edit_cel").val(),
                "email": $("#edit_email").val(),
                "site": $("#edit_site").val(),
                "endereco": $("#edit_endereco").val(),
                "numero": $("#edit_numero").val(),
                "complemento": $("#edit_complemento").val(),
                "bairro": $("#edit_bairro").val(),
                "cidade": $("#edit_cidade").val(),
                "uf": $("#edit_uf").val(),
                "cep": $("#edit_cep").val(),
                "status": $("#edit_status").val(),
                "localizacao": $("#edit_localizacao").val()
            };

            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'PUT',
                contentType: 'application/json',
                data: JSON.stringify(formData),
                success: function(response) {
                    alert('Registro atualizado com sucesso!');
                    $('#editModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao atualizar o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });

        // Excluir registro
        $(document).on('click', '.btn-delete', function() {
            var id = $(this).data('id');
            $('#deleteId').val(id);
            $('#deleteModal').modal('show');
        });

        // Confirmar exclusão
        $('#confirmDelete').click(function() {
            var id = $('#deleteId').val();

            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'DELETE',
                success: function(response) {
                    alert('Registro excluído com sucesso!');
                    $('#deleteModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao excluir o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });

        // Submit do formulário de cadastro
        $('#cadastrarForm').submit(function(e) {
            e.preventDefault();
            var formData = {
                "logo": $("#logo").val(),
                "cnpj": $("#cnpj").val(),
                "insc_est": $("#insc_est").val(),
                "insc_mun": $("#insc_mun").val(),
                "nome_rs": $("#nome_rs").val(),
                "nome_fan": $("#nome_fan").val(),
                "nome_representante": $("#nome_representante").val(),
                "cpf": $("#cpf").val(),
                "fone": $("#fone").val(),
                "fax": $("#fax").val(),
                "cel": $("#cel").val(),
                "email": $("#email").val(),
                "site": $("#site").val(),
                "endereco": $("#endereco").val(),
                "numero": $("#numero").val(),
                "complemento": $("#complemento").val(),
                "bairro": $("#bairro").val(),
                "cidade": $("#cidade").val(),
                "uf": $("#uf").val(),
                "cep": $("#cep").val(),
                "status": $("#status").val(),
                "localizacao": $("#localizacao").val()
            };

            $.ajax({
                url: '<?= $api_url ?>',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(formData),
                success: function(response) {
                    alert('Registro cadastrado com sucesso!');
                    $('#cadastrarModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao cadastrar o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });
    });
    </script>
</body>

</html>